({

/* ----------------------------------------------------------------------------------------
   ----------------------------------------------------------------------------------------
   'q_property.js' : custom javascript file to customize QxEntityEditor C++ export process.
   This script is an example to show how to use QxEntityEditor javascript engine to add a Q_PROPERTY definition for each property generated by QxEntityEditor.
   More details about Q_PROPERTY macro on Qt web site : http://doc.qt.io/qt-5/properties.html

   To use this javascript file :
      1- go to the main menu of QxEntityEditor 'Tools >> Export to C++ project (settings)' ;
      2- select the C++ template 'qx::IxPersistable + QObject' : now generated entities will inherit from QObject, which is required to use the Qt Q_PROPERTY macro ;
      3- in the field 'Custom script file' : put the location of this 'q_property.js' custom javascript file ;
      4- save the settings and start the C++ export process ;
      5- check generated files : Q_PROPERTY should be added automatically by the export process.
   ----------------------------------------------------------------------------------------
   ---------------------------------------------------------------------------------------- */

// Here is the entry point of the QxEntityEditor javascript engine
// This function is called for each placeholder defined in the C++ template section
customProcess : function(params)
{
   try
   {
      // We use here the @@MACRO_QX_PERSISTABLE_HPP@@ placeholder which is present in the default C++ template 'qx::IxPersistable + QObject'
      // You could also create your own custom C++ template (based on 'qx::IxPersistable + QObject' template), and create your own placeholder (which must be prefixed by @@CUSTOM_), for example : @@CUSTOM_Q_PROPERTY@@
      var action = params[5];
      if (action != "MACRO_QX_PERSISTABLE_HPP") { return params[0]; } // quit with 'params[0]' means : doesn't change the default export behaviour

      // Check if we have an entity
      var entity_id = params[13];
      if ((entity_id == "") || (entity_id == "0")) { return params[0]; } // quit with 'params[0]' means : doesn't change the default export behaviour

      // Get the list of properties
      var entity_details = helper.getEntityDetails(entity_id);
      var entity_list_of_properties_id = ((entity_details.length > 0) ? entity_details[10] : "");
      var entity_list_of_properties_array = entity_list_of_properties_id.split("|");
      if (entity_list_of_properties_array.length <= 0) { return params[0]; } // quit with 'params[0]' means : doesn't change the default export behaviour

      // Prepare output string
      var output = params[0] + "\n";

      // Iterate over each property
      for (var idx = 0; idx < entity_list_of_properties_array.length; idx++)
      {
         // Get property details
         var property_id = entity_list_of_properties_array[idx];
         var property_details = helper.getPropertyDetails(property_id);

         // Here you could also get property meta-data that you can define in QxEntityEditor, property parameters screen, section 'List of meta-data'
         // This is a way to manage your own property parameters which are not a part of QxEntityEditor
         // It could be useful for example to manage some Q_PROPERTY settings like : RESET, NOTIFY, REVISION, DESIGNABLE, SCRIPTABLE, FINAL, etc...
         // To get a property meta-data value, just write this code : var my_meta_data = helper.getPropertyMetaData(property_id, "MY_META_DATA_KEY");

         // Get property type and name
         var property_type = property_details[5];
         var property_name = property_details[2];

         // Check if property type can be used with Q_PROPERTY macro
         if (list_of_compatible_property_type.indexOf(property_type) == -1) { continue; }

         // Create Q_PROPERTY definition
         output += "\n   Q_PROPERTY(" + property_type + " " + property_name + " READ get" + property_name + " WRITE set" + property_name + ")";
      }

      return output;
   }
   catch (err)
   { return ("[CustomScriptError] an unexpected error occurred : " + err); }
}

});

// Here is a list of C++ types compatible with Qt Q_PROPERTY macro (C++ type can be converted to/from QVariant)
// You can of course register your own C++ types to be able to use them with Q_PROPERTY macro (using Qt Q_DECLARE_METATYPE() macro)
// So the following array is not fixed : you can add all C++ types you want...
var list_of_compatible_property_type = [ "QBitArray", "QBitmap", "bool", "QBrush", "QByteArray", "QChar", "QColor", "QDate", "QDateTime", "double", 
                                         "QUuid", "QFont", "QVariantHash", "QIcon", "QImage", "int", "QLine", "QLineF", "QVariantList", "qlonglong", 
                                         "QVariantMap", "QMatrix", "QMatrix4x4", "QPixmap", "QPoint", "QPointF", "QPolygon", "QPolygonF", "QRect", "QRectF", 
                                         "QRegExp", "QRegion", "QSize", "QSizeF", "QString", "QStringList", "QTime", "uint", "qulonglong", "QUrl", 
                                         "QVector2D", "QVector3D", "QVector4D" ];
